﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nfp.h>

namespace nfpdebug {

/**
 * @brief   英語名のサンプル
 */
const char SampleNameEn[] = "Owner";

/**
 * @brief   日本語名のサンプル
 */
const char SampleNameJp[] = "オーナー";

/**
 * @brief   中国語名のサンプル
 */
const char SampleNameCh[] = "所有者";

/**
 * @brief   韓国語名のサンプル
 */
const char SampleNameKo[] = "오너";

/**
 * @brief   台湾名のサンプル
 */
const char SampleNameTw[] = "所有者";

/**
 * @brief   ガイドラインチェック用のニックネーム (UTF-16 BE)
 */
const char16_t NicknameForGuidelineCheck[nn::nfp::NicknameLengthMax + 1] =
{
    0x0108,  // Ĉ
    0x0109,  // ĉ
    0x0114,  // Ĕ
    0x0115,  // ĕ
    0x011C,  // Ĝ
    0x011D   // ĝ
};

}  // nfpdebug
