﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <string>

namespace {
    const int MaxHashNum = 32768;
}

class HashList
{
private:
    std::string partitionName;
    std::string hashValue[MaxHashNum];
    int storedSize;

public:
    HashList() NN_NOEXCEPT
        : storedSize(0)
    {
    }

    void AddHash(std::string value) NN_NOEXCEPT
    {
        hashValue[storedSize] = value;
        ++storedSize;
    }

    void SetTitle(std::string value) NN_NOEXCEPT
    {
        partitionName = value;
    }

    void Sort() NN_NOEXCEPT
    {
        std::sort(hashValue, hashValue + storedSize);
    }

    std::string GetPartitionName() NN_NOEXCEPT
    {
        return partitionName;
    }

    int GetStoredSize() NN_NOEXCEPT
    {
        return storedSize;
    }

    std::string GetHashValue(int pos) NN_NOEXCEPT
    {
        return hashValue[pos];
    }
};
