﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/crypto/crypto_Sha256Generator.h>

class HashGenerator
{
private:
    nn::crypto::Sha256Generator m_Generator;

public:
    HashGenerator() NN_NOEXCEPT
    {}

    void Initialize() NN_NOEXCEPT
    {
        m_Generator.Initialize();
    }

    void Update(const void* pData, size_t dataSize) NN_NOEXCEPT
    {
        m_Generator.Update(pData, dataSize);
    }

    void GetHash(void* pHash, size_t hashSize) NN_NOEXCEPT
    {
        m_Generator.GetHash(pHash, hashSize);
    }

    size_t GetHashSize() const NN_NOEXCEPT
    {
        return m_Generator.HashSize;
    }
};
