﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NandVerifier_Allocator.h"
#include <cstdlib>

namespace
{
    const size_t AllocatorBufferSize = 1 * 1024 * 1024 * 1024;
    static uint8_t s_AllocatorBuffer[AllocatorBufferSize];
    static nn::mem::StandardAllocator s_Allocator(s_AllocatorBuffer, AllocatorBufferSize);
}

void* Allocate(size_t size, size_t alignment, void* userPtr) NN_NOEXCEPT
{
    NN_UNUSED(userPtr);
    return aligned_alloc(alignment, size);
}

void Deallocate(void* address, void* userPtr) NN_NOEXCEPT
{
    NN_UNUSED(userPtr);
    free(address);
}

void* Reallocate(void* address, size_t size, void* userPtr) NN_NOEXCEPT
{
    NN_UNUSED(userPtr);
    return realloc(address, size);
}

void* Allocate(size_t size) NN_NOEXCEPT
{
    return s_Allocator.Allocate(size);
}

void Deallocate(void* p, size_t size) NN_NOEXCEPT
{
    NN_UNUSED(size);
    return s_Allocator.Free(p);
}

#ifndef NN_BUILD_CONFIG_OS_WIN32

void * operator new (std::size_t size) NN_NOEXCEPT
{
    return s_Allocator.Allocate(size);
}

void operator delete (void * ptr) NN_NOEXCEPT
{
    s_Allocator.Free(ptr);
}

#endif
