﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "VibrationDemo_SceneBase.h"

namespace VibrationDemo
{
    nns::hidfw::layout::BaseItemSet        SceneBase::m_VibrationViewer;
    nns::hidfw::layout::LineChart          SceneBase::m_FrequencyDrawerForLeft;
    nns::hidfw::layout::BarChart           SceneBase::m_AmplitudeDrawerForLeft;
    nns::hidfw::layout::LineChart          SceneBase::m_FrequencyDrawerForRight;
    nns::hidfw::layout::BarChart           SceneBase::m_AmplitudeDrawerForRight;
    bool                            SceneBase::m_IsShowVibration;
    bool                            SceneBase::m_IaMoveVibrationViewer;

    SceneBase::SceneBase() NN_NOEXCEPT
    {
        static bool isInitialized = false;
        if (!isInitialized)
        {
            isInitialized = true;
            m_IsShowVibration = true;
            m_FrameCount = 0;

            m_FrequencyDrawerForLeft.SetDefault();
            m_FrequencyDrawerForLeft.SetPos(10, 555);
            m_FrequencyDrawerForLeft.SetSize(300, 150);
            m_FrequencyDrawerForLeft.SetMainColor(nn::util::Color4u8(0, 0, 0, 128));
            m_FrequencyDrawerForLeft.SetBorderColor(nn::util::Color4u8(0, 32, 0, 255));
            m_FrequencyDrawerForLeft.AddElement(nns::hidfw::layout::LineChart::CreateElement(nn::util::Color4u8(16, 96, 242, 255), "Low", 600, 1.f, 0.f, 1.25f));
            m_FrequencyDrawerForLeft.AddElement(nns::hidfw::layout::LineChart::CreateElement(Color::NintendoRed, "Hi", 600, 1.f, 0.f, 1.25f));
            m_FrequencyDrawerForLeft.SetChooseMode(nns::hidfw::layout::BaseItem::ChoiceMode::None::Mask);
            m_FrequencyDrawerForLeft.SetText(" Left amplitude");

            m_AmplitudeDrawerForLeft.SetPos(325, 555);
            m_AmplitudeDrawerForLeft.SetSize(300, 150);
            m_AmplitudeDrawerForLeft.SetMainColor(nn::util::Color4u8(0, 0, 0, 128));
            m_AmplitudeDrawerForLeft.SetBorderColor(nn::util::Color4u8(0, 32, 0, 255));
            m_AmplitudeDrawerForLeft.SetMaxVerticalValue(1.f);
            m_AmplitudeDrawerForLeft.SetMinVerticalValue(0.f);
            m_AmplitudeDrawerForLeft.SetMaxHorizontalValue(400.f);
            m_AmplitudeDrawerForLeft.SetMinHorizontalValue(80.f);
            m_AmplitudeDrawerForLeft.SetViewerMode(nns::hidfw::layout::BarChart::ViewerMode_Music);
            m_AmplitudeDrawerForLeft.SetDivisionCount(30);
            m_AmplitudeDrawerForLeft.SetChooseMode(nns::hidfw::layout::BaseItem::ChoiceMode::None::Mask);
            m_AmplitudeDrawerForLeft.SetText(" Left frequency");

            m_FrequencyDrawerForRight.SetDefault();
            m_FrequencyDrawerForRight.SetPos(650, 555);
            m_FrequencyDrawerForRight.SetSize(300, 150);
            m_FrequencyDrawerForRight.SetMainColor(nn::util::Color4u8(0, 0, 0, 128));
            m_FrequencyDrawerForRight.SetBorderColor(nn::util::Color4u8(0, 32, 0, 255));
            m_FrequencyDrawerForRight.AddElement(nns::hidfw::layout::LineChart::CreateElement(nn::util::Color4u8(16, 96, 242, 255), "Low", 600, 1.f, 0.f, 1.25f));
            m_FrequencyDrawerForRight.AddElement(nns::hidfw::layout::LineChart::CreateElement(Color::NintendoRed, "Hi", 600, 1.f, 0.f, 1.25f));
            m_FrequencyDrawerForRight.SetChooseMode(nns::hidfw::layout::BaseItem::ChoiceMode::None::Mask);
            m_FrequencyDrawerForRight.SetText(" Right amplitude");

            m_AmplitudeDrawerForRight.SetDefault();
            m_AmplitudeDrawerForRight.SetPos(965, 555);
            m_AmplitudeDrawerForRight.SetSize(300, 150);
            m_AmplitudeDrawerForRight.SetMainColor(nn::util::Color4u8(0, 0, 0, 128));
            m_AmplitudeDrawerForRight.SetBorderColor(nn::util::Color4u8(0, 32, 0, 255));
            m_AmplitudeDrawerForRight.SetMaxVerticalValue(1.f);
            m_AmplitudeDrawerForRight.SetMinVerticalValue(0.f);
            m_AmplitudeDrawerForRight.SetMaxHorizontalValue(400.f);
            m_AmplitudeDrawerForRight.SetMinHorizontalValue(80.f);
            m_AmplitudeDrawerForRight.SetViewerMode(nns::hidfw::layout::BarChart::ViewerMode_Music);
            m_AmplitudeDrawerForRight.SetDivisionCount(30);
            m_AmplitudeDrawerForRight.SetChooseMode(nns::hidfw::layout::BaseItem::ChoiceMode::None::Mask);
            m_AmplitudeDrawerForRight.SetText(" Right frequency");

            m_VibrationViewer.Add(&m_FrequencyDrawerForLeft);
            m_VibrationViewer.Add(&m_FrequencyDrawerForRight);
            m_VibrationViewer.Add(&m_AmplitudeDrawerForLeft);
            m_VibrationViewer.Add(&m_AmplitudeDrawerForRight);
        }
    }

    void SceneBase::UpdateVibrationViewer() NN_NOEXCEPT
    {
        const auto useNpadId = gControllerSequenceManager.GetMasterControllerId();

        static int64_t prevSamplingNumber[2] = { 0, 0 };
        nn::hid::VibrationValue value[5];

        // Left
        auto count = gVibrationManager.GetActualVibrationValues(useNpadId, nn::hid::NpadJoyDeviceType_Left, value, NN_ARRAY_SIZE(value), prevSamplingNumber[nn::hid::NpadJoyDeviceType_Left], &prevSamplingNumber[nn::hid::NpadJoyDeviceType_Left]);

        if (count > 0)
        {
            for (auto i = count; i > 0; --i)
            {
                m_AmplitudeDrawerForLeft.AddValue(value[i - 1].frequencyLow, value[i - 1].amplitudeLow);
                m_AmplitudeDrawerForLeft.AddValue(value[i - 1].frequencyHigh, value[i - 1].amplitudeHigh);
                m_FrequencyDrawerForLeft.AddValue(0, value[i - 1].amplitudeLow);
                m_FrequencyDrawerForLeft.AddValue(1, value[i - 1].amplitudeHigh);
            }
        }
        else
        {
            for (auto i = 0; i < 3; ++i)
            {
                m_AmplitudeDrawerForLeft.AddValue(0.f, 0.f);
                m_FrequencyDrawerForLeft.AddValue(0, 0.f);
                m_FrequencyDrawerForLeft.AddValue(1, 0.f);
            }
        }

        // Right
        count = gVibrationManager.GetActualVibrationValues(useNpadId, nn::hid::NpadJoyDeviceType_Right, value, NN_ARRAY_SIZE(value), prevSamplingNumber[nn::hid::NpadJoyDeviceType_Right], &prevSamplingNumber[nn::hid::NpadJoyDeviceType_Right]);

        if (count > 0)
        {
            for (auto i = count; i > 0; --i)
            {
                m_AmplitudeDrawerForRight.AddValue(value[i - 1].frequencyLow, value[i - 1].amplitudeLow);
                m_AmplitudeDrawerForRight.AddValue(value[i - 1].frequencyHigh, value[i - 1].amplitudeHigh);
                m_FrequencyDrawerForRight.AddValue(0, value[i - 1].amplitudeLow);
                m_FrequencyDrawerForRight.AddValue(1, value[i - 1].amplitudeHigh);
            }
        }
        else
        {
            for (auto i = 0; i < 3; ++i)
            {
                m_AmplitudeDrawerForRight.AddValue(0.f, 0.f);
                m_FrequencyDrawerForRight.AddValue(0, 0.f);
                m_FrequencyDrawerForRight.AddValue(1, 0.f);
            }
        }

        m_VibrationViewer.Update();

        if (gController.GetController(useNpadId)->IsTrigger(nn::hid::NpadButton::Minus::Mask))
        {
            m_IsShowVibration ^= true;
        }
    }

    void SceneBase::DrawVibrationViewer() NN_NOEXCEPT
    {
        if (m_IsShowVibration)
        {
            gFont.DrawText();
            gFont.SetSize(8);
            m_VibrationViewer.Draw();
            gDrawer.SetColor(nn::util::Color4u8(255, 255, 255, 128));

            for (const auto& itr : m_VibrationViewer.GetItemSet())
            {
                gFont.SetPos(itr->GetPos().x, itr->GetPos().y - 24.f);
                gFont.Print("%s", itr->GetText().c_str());
                gDrawer.Draw2DFrame(itr->GetPos(), itr->GetSize(), 1.f);
            }
            gFont.DrawText();
        }
    }

    bool SceneBase::DoMainLoop() NN_NOEXCEPT
    {
        Initialize();

        while (m_IsExit == false)
        {
            while (gControllerSequenceManager.TryWait())
            {
                nn::os::SleepThread(gControllerSequenceManager.GetEventInterval());
            }

            gInput.Update();

            Update();

            UpdateVibrationViewer();

            gDrawer.BeginDraw();
            {
                Draw();

                DrawVibrationViewer();
            }
            gDrawer.EndDraw();

            ++m_FrameCount;
        }

        Finalize();

        return m_SceneResult;
    }

    void SceneBase::ExitScene() NN_NOEXCEPT
    {
        m_SceneResult = true;
        m_IsExit = true;
    }

    void SceneBase::ExitApplication() NN_NOEXCEPT
    {
        m_SceneResult = false;
        m_IsExit = true;
    }
}
