﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_TimeSpan.h>

#include "VibrationDemo_Scene.h"

namespace VibrationDemo
{
    class ApplicationState
    {
        NN_DISALLOW_COPY(ApplicationState);
        NN_DISALLOW_MOVE(ApplicationState);
    public:
        static ApplicationState& GetInstance() NN_NOEXCEPT
        {
            static ApplicationState instance;
            return instance;
        }
        void Initialize() NN_NOEXCEPT
        {
            m_StartTime = nn::os::GetSystemTick().ToTimeSpan();
            m_IsExit = false;
            m_FrameCount = 0;
            m_pScene = nullptr;
        }
        void            SetStartTime() NN_NOEXCEPT { m_StartTime = nn::os::GetSystemTick().ToTimeSpan(); }
        nn::TimeSpan    GetStartTime() const NN_NOEXCEPT { return m_StartTime; }
        void            Exit() NN_NOEXCEPT { m_IsExit = true; }
        bool            IsExit() const NN_NOEXCEPT { return m_IsExit; }
        uint64_t        GetFrameCount() const NN_NOEXCEPT { return m_FrameCount; }
        void            AddFrameCount() NN_NOEXCEPT { ++m_FrameCount; }
        void            SetScene(SceneBase* pScene) NN_NOEXCEPT { m_pScene = pScene; }
        SceneBase*      GetScene() NN_NOEXCEPT { return m_pScene; }
    private:
        ApplicationState() NN_NOEXCEPT {}
    private:
        nn::TimeSpan    m_StartTime;
        bool            m_IsExit;
        uint64_t        m_FrameCount;
        SceneBase*      m_pScene;
    };
}
#define gApplicationState (VibrationDemo::ApplicationState::GetInstance())
