﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
/*
 * 振動の処理
 */

#include <nn/audio.h>
#include <nns/audio/audio_HidUtilities.h>
#include <nns/audio/audio_WavFormat.h>
#include <nn/nn_TimeSpan.h>

#include "Base.h"
#include "File.h"

namespace VibrationCollection
{

    extern VibrationTarget                          g_VibrationTarget;
    extern nns::hid::SpeedChangeableVibrationPlayer g_VibrationPlayer;

    class VibrationUpdateThread
    {
    public:
        static const size_t                     StackSize = 1024 * 1024 * 64;
    private:
        static NN_OS_ALIGNAS_THREAD_STACK char  ThreadStack[StackSize];
        static nn::os::ThreadType               VibrationThread;
        static nn::os::TimerEventType           VibrationTimerEvent;
    private:
        static void VibrationNodeThreadFunction(void *arg) NN_NOEXCEPT;
    public:
        static void Initialize() NN_NOEXCEPT;
        static void Finalize() NN_NOEXCEPT;
        static void Start() NN_NOEXCEPT;
    };

    void PlayVibration(void* pushButton, void* param) NN_NOEXCEPT;

    void ExportVibrationValue(
        uint8_t* outBuffer,
        size_t bufferSize,
        size_t* pOutSize
    ) NN_NOEXCEPT;
}
