﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/swkbd/swkbd_Api.h>
#include "Button.h"

namespace VibrationCollection
{
    struct ExportDialogButton
    {
        static nns::hidfw::layout::ButtonGroup closeButton;        // 閉じるボタン
        static nns::hidfw::layout::ButtonGroup closeExportDialogButton;
        static nns::hidfw::layout::ButtonGroup renameButtons[2];   // パスとファイル名のリネームボタン
        static nns::hidfw::layout::ButtonGroup mainButton;         // 出力ボタンとキャンセルボタン

        static nns::hidfw::layout::ButtonGroup inputPathButtons;
        static nns::hidfw::layout::ButtonGroup changeMountTargetButtons;
        static nns::hidfw::layout::ButtonGroup changePathButtons;
    };

    struct ExportBnvibFile
    {
        static std::string path;
        static std::string fileName;
        static std::string openPath;
    };

    void ShowSwkbd(void* pushButton, void* param) NN_NOEXCEPT;

    void CallExportVibrationValue(void* pushButton, void* param) NN_NOEXCEPT;

    void CallChangeDirectory(void* pushButton, void* param) NN_NOEXCEPT;

    void CallChangeMountTarget(void* pushButton, void* param) NN_NOEXCEPT;

    void ShowExportBnvibDialog(void* pushButton, void* param) NN_NOEXCEPT;

    void ShowOpenDirectoryDialog(void* pushButton, void* param) NN_NOEXCEPT;

    void InitializeMainButtons(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeRenameButtons(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeCloseButton(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeInputPathButton(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeChangeMountTargetButton(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeChangePathButton(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void UpdateExportBnvibDialog(void* executant, void* param) NN_NOEXCEPT;

    void DrawExportBnvibDialog(void* executant, void* param) NN_NOEXCEPT;

    void UpdateOpenDirectoryDialog(void* executant, void* param) NN_NOEXCEPT;

    void DrawOpenDirectoryDialog(void* executant, void* param) NN_NOEXCEPT;
}
