﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
/*
 * 起動時引数の処理
 */

#include <nn/nn_TimeSpan.h>

#include <nn/audio.h>
#include <nns/audio/audio_HidUtilities.h>
#include <nns/audio/audio_WavFormat.h>

#include "Base.h"
#include "File.h"

namespace VibrationCollection
{
    struct StartupCommand
    {
        typedef ::nn::util::BitFlagSet<32, StartupCommand>::Flag<0> None;    //!< SD/Host 無効化 -sd / - host の直後に来た場合は直前のもののみ無効化
        typedef ::nn::util::BitFlagSet<32, StartupCommand>::Flag<1> Host;    //!< Hostの参照先を次の引数の値に変更 -none で無効化
        typedef ::nn::util::BitFlagSet<32, StartupCommand>::Flag<2> SD;      //!< SDの参照先を次の引数の値に変更 -none で無効化
    };
    typedef ::nn::util::BitFlagSet<32, StartupCommand> StartupCommandSet;

    void StartupArgument() NN_NOEXCEPT;
}
