﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include "Button.h"

namespace VibrationCollection
{
    enum AssertDialogType
    {
        AssertDialogType_Warning,       // 黄色いデザインになります
        AssertDialogType_Error,         // 赤いデザインになります
        AssertDialogType_Info           // 青いデザインになります
    };

    enum AssertButtonType
    {
        AssertButtonType_OK,            // ユーザーに選択権がなく終了される場合
        AssertButtonType_YesNo,         // 処理の続行判断をユーザーに委ねます
        AssertButtonType_Success        // 成功メッセージを表示
    };

    nns::hidfw::layout::Dialog::DialogResult ShowAssertDialog(std::string title, std::string message, AssertDialogType dialogType, AssertButtonType buttonType) NN_NOEXCEPT;

    void InitializeAssertDialogButtons(nns::hidfw::layout::Dialog* pDialog) NN_NOEXCEPT;

    void UpdateAssertDialog(void* executant, void* param) NN_NOEXCEPT;

    void DrawAssertDialog(void* executant, void* param) NN_NOEXCEPT;
}
