﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_ScopeExit.h>

#include "StringTable.h"

namespace nns { namespace hid { namespace util {

JsonResult StringTable::Open(const char* filename) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(filename);

    Close();
    return m_Json.Open(filename);
}

void StringTable::Close() NN_NOEXCEPT
{
    if (m_Json.IsOpened())
    {
        m_Json.Close();
    }
}

const char* StringTable::Get(const char* key) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(key);
    NN_ASSERT(m_Json.IsOpened());

    const auto* langKey = GetLanguageKey();
    const auto& doc     = m_Json.GetDocument();
    if (doc.HasMember(key) &&
        doc[key].HasMember(langKey) &&
        doc[key][langKey].IsString())
    {
        auto* str = doc[key][langKey].GetString();
        return str[0] == '\0' ? "????" : str;
    }
    else
    {
        return "----";
    }
}

}}}  // nns::hid::util
