﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <mutex>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_CharacterEncoding.h>
#include <nn/util/util_StringUtil.h>

#include "../SimpleGfx.h"
#include "SimpleGfx_GuiWaitIcon.h"

namespace nns { namespace sgx { namespace gui {

namespace {

// アニメーション間隔の初期値
const int DefaultWaitIconInterval = 5;

// アニメーションの総フレーム数
const int IconFrameCount = 8;

}  // anonymous

WaitIcon::WaitIcon() NN_NOEXCEPT
    : m_Duration(0)
    , m_Interval(DefaultWaitIconInterval)
{
}

void WaitIcon::Update() NN_NOEXCEPT
{
    NNS_SGX_GUI_SCOPED_LOCK;

    if (!IsVisible())
    {
        return;
    }

    if (m_Duration % m_Interval == 0)
    {
        uint32_t index = m_Duration / m_Interval;
        uint32_t icon[] = { 0xE020u + index, 0u };
        SetText(icon);
    }

    m_Duration++;
    if (m_Duration >= m_Interval * IconFrameCount)
    {
        m_Duration = 0;
    }

    Label::Update();
}

}}}  // nns::sgx::gui
