﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiCommonDefs.h"
#include "SimpleGfx_GuiObject.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   スクロールバーを扱うクラスです。
 */
class ScrollBar :
    public DisplayObject
{
    NN_DISALLOW_COPY(ScrollBar);
    NN_DISALLOW_MOVE(ScrollBar);

public:
    /**
     * @brief   スクロール方向です。
     */
    enum class ScrollDirection
    {
        Vertical,
        Horizontal
    };

public:
    ScrollBar() NN_NOEXCEPT;

    void SetDirection(ScrollDirection direction) NN_NOEXCEPT
    {
        m_Direction = direction;
    }

    void SetValue(float value) NN_NOEXCEPT
    {
        m_Value = std::min(std::max(value, m_MinValue), m_MaxValue);
    }

    void SetMinValue(float value) NN_NOEXCEPT
    {
        m_MinValue = std::min(value, m_MaxValue);
        SetValue(m_Value);
    }

    void SetMaxValue(float value) NN_NOEXCEPT
    {
        m_MaxValue = std::max(value, m_MinValue);
        SetValue(m_Value);
    }

    void SetStepValue(float value) NN_NOEXCEPT
    {
        // 制限は仮置き
        m_StepValue = std::min(std::max(value, 0.01f), m_MaxValue);
    }

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    ScrollDirection m_Direction;
    float           m_Value;
    float           m_MinValue;
    float           m_MaxValue;
    float           m_StepValue;
};

}}}  // nns::sgx::gui
