﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <mutex>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_CharacterEncoding.h>
#include <nn/util/util_StringUtil.h>

#include "../SimpleGfx.h"
#include "SimpleGfx_GuiScrollBar.h"

namespace nns { namespace sgx { namespace gui {

namespace
{

const float MarkLengthMin = 8.0f;

}  // anonymous

ScrollBar::ScrollBar() NN_NOEXCEPT
    : m_Direction(ScrollDirection::Vertical)
    , m_Value(0.0f)
    , m_MinValue(0.0f)
    , m_MaxValue(0.0f)
    , m_StepValue(1.0f)
{
}

void ScrollBar::Update() NN_NOEXCEPT
{
    NNS_SGX_GUI_SCOPED_LOCK;

    if (!IsVisible())
    {
        return;
    }
}

void ScrollBar::Render() NN_NOEXCEPT
{
    NNS_SGX_GUI_SCOPED_LOCK;

    if (!IsVisible())
    {
        return;
    }

    Rectangle rect = { { GetX(), GetY(), GetWidth(), GetHeight() } };
    auto opacity = GetDisplayOpacity();
    const auto& baseLineColor = nns::sgx::Colors::DimGray().BlendAlpha(opacity);
    const auto& markFrameColor = nns::sgx::Colors::Smoke().BlendAlpha(opacity);
    const auto& markColor = nns::sgx::Colors::WhiteSmoke().BlendAlpha(opacity);

    if (m_Direction == ScrollDirection::Vertical)
    {
        // ベースライン
        float lineX = rect.x + rect.width / 2;
        float length = rect.height;
        nns::sgx::DrawLine(lineX, rect.y, lineX, rect.y + length, baseLineColor, 1.5f);

        // マーカー
        float rate = 1.0f * (m_Value - m_MinValue) / (m_MaxValue - m_MinValue);
        float markLength = std::max(length / m_StepValue, MarkLengthMin);
        float markY = rect.y + (length - markLength) * rate;
        nns::sgx::DrawRectangle(rect.x, markY, rect.width, markLength, markFrameColor, 1.0f);
        nns::sgx::FillRectangle(rect.x + 1, markY + 1, rect.width - 2, markLength - 2, markColor);
    }
    else
    {
        // TODO: 水平バー
    }
}

}}}  // nns::sgx::gui
