﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <mutex>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_CharacterEncoding.h>
#include <nn/util/util_StringUtil.h>

#include "../SimpleGfx.h"
#include "SimpleGfx_GuiProgressBar.h"
#include "SimpleGfx_GuiUtil.h"

namespace nns { namespace sgx { namespace gui {

Rectangle ProgressBar::GetClientArea() const NN_NOEXCEPT
{
    Rectangle rect;
    GetRenderPosition(&rect.position);
    GetSize(&rect.size);

    return rect;
}

void ProgressBar::Update() NN_NOEXCEPT
{
    NNS_SGX_GUI_SCOPED_LOCK;

    if (!IsVisible())
    {
        return;
    }

    if (m_Value != GetDisplayValue())
    {
        float diff = m_Value - m_DispValue;
        if (std::fabsf(diff) < 1.0f)
        {
            m_DispValue = m_Value;
        }
        else if (diff > 0)
        {
            m_DispValue += 0.5f;
        }
        else
        {
            m_DispValue -= 0.5f;
        }
    }
}

void ProgressBar::Render() NN_NOEXCEPT
{
    NNS_SGX_GUI_SCOPED_LOCK;

    if (!IsVisible())
    {
        return;
    }

    auto rect = GetClientArea();
    ApplyRenderArea(rect);
    DrawBar();
    RestoreRenderArea();
    NNS_SGX_GUI_DRAW_CLIENT_AREA_DEBUG(rect);
}

void ProgressBar::DrawBar() NN_NOEXCEPT
{
    auto opacity = GetDisplayOpacity();
    auto rate    = GetDispRate();
    auto size    = GetSize();
    FillRectangle(
        size.width * rate,
        0,
        size.width * (1.0f - rate),
        size.height,
        Colors::Silver().BlendAlpha(opacity));
    FillRectangle(
        0,
        0,
        size.width * rate,
        size.height,
        Colors::RoyalBlue().BlendAlpha(opacity));
}

}}}  // nns::sgx::gui
