﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <algorithm>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiCommon.h"
#include "SimpleGfx_GuiProgressBar.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   円形プログレスバーを扱うクラスです。
 */
class CircleProgressBar :
    public ProgressBar
{
    NN_DISALLOW_COPY(CircleProgressBar);
    NN_DISALLOW_MOVE(CircleProgressBar);

public:
    CircleProgressBar() NN_NOEXCEPT
        : m_BarWidth(9.0f)
        , m_Duration(0)
        , m_GradImage()
    {
        SetSize(64, 64);
    }

    virtual ~CircleProgressBar() NN_NOEXCEPT;

    /**
     * @brief   バーの太さを設定します。
     */
    void SetBarWidth(float width) NN_NOEXCEPT
    {
        m_BarWidth = width;
    }

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

private:
    /**
     * @brief   バー本体を描画します。
     */
    virtual void DrawBar() NN_NOEXCEPT NN_OVERRIDE;

private:
    float               m_BarWidth;
    int                 m_Duration;
    nns::sgx::ImageData  m_GradImage;
};

}}}  // nns::sgx::gui
