﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../SimpleGfx.h"
#include "SimpleGfx_GuiCanvas.h"
#include "SimpleGfx_GuiUtil.h"

namespace nns { namespace sgx { namespace gui {

Size Canvas::GetClientAreaSize() const NN_NOEXCEPT
{
    return GetSize();
}

Rectangle Canvas::GetClientArea() const NN_NOEXCEPT
{
    Rectangle rect;
    rect.x    = GetX();
    rect.y    = GetY();
    rect.size = GetClientAreaSize();

    return rect;
}

void Canvas::Render() NN_NOEXCEPT
{
    NNS_SGX_GUI_SCOPED_LOCK;

    if (!IsVisible())
    {
        return;
    }

    // コンテンツ領域の描画開始
    {
        auto rect = GetClientArea();
        NNS_SGX_GUI_DRAW_CLIENT_AREA_DEBUG(rect);
        nns::sgx::ApplyRenderArea(rect);
    }

    RenderContents();
    m_HandlerForRenderContents.Invoke(this);

    // コンテンツ領域の描画終了
    nns::sgx::RestoreRenderArea();
}

}}}  // nns::sgx::gui
