﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiCommonDefs.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   ボタンのスキンです。
 */
class ButtonSkin final
{
    NN_DISALLOW_COPY(ButtonSkin);
    NN_DISALLOW_MOVE(ButtonSkin);

    friend class Button;

public:
    ButtonSkin() NN_NOEXCEPT;

    ~ButtonSkin() NN_NOEXCEPT;

    void SetDefault() NN_NOEXCEPT;

    ResultCode Load(const char* filename) NN_NOEXCEPT;

    void Destroy() NN_NOEXCEPT;

private:
    ImageData   m_BaseImage;            //!< ベース画像
    Point2D     m_BaseOffset;           //!< ベース画像の描画位置補正
    Size        m_BaseSizeOffset;       //!< ベース画像のサイズ補正
    Padding     m_ContentsPadding;      //!< コンテンツ領域までのパディング
    Color       m_NormalTextColor;      //!< 通常時の文字色
};

}}}  // nns::sgx::gui
