﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "hid_ControllerManager.h"

namespace nns { namespace hidfw { namespace hid {

    void ControllerManager::Initialize() NN_NOEXCEPT
    {
        /*
         * ControllerManager が管理するNpadIdを指定します
         * 各NpadIdの振動や六軸センサのハンドルの取得が行われますが、
         * Npad 自体の初期化処理やNpadIdの有効化処理は実行されないため
         * 別途実装して下さい
         */
        nn::hid::NpadIdType npadIds[] =
        {
            nn::hid::NpadId::No1,
            nn::hid::NpadId::No2,
            nn::hid::NpadId::No3,
            nn::hid::NpadId::No4,
            nn::hid::NpadId::No5,
            nn::hid::NpadId::No6,
            nn::hid::NpadId::No7,
            nn::hid::NpadId::No8,
            nn::hid::NpadId::Handheld
        };

        nns::hidfw::hid::Controller::InitializeInfo info;      // Controllerの初期化パラメータ
        info.isNpad = true;                             // Npad であることを前提とし、初期化します

        for (size_t i = 0; i < NN_ARRAY_SIZE(npadIds); ++i)
        {
            info.npadId = npadIds[i];
            m_pControllerList.push_back(new nns::hidfw::hid::Controller());
            m_pControllerList.back()->Initialize(info);
        }
    }

    void ControllerManager::Finalize() NN_NOEXCEPT
    {
        for (
            std::vector<nns::hidfw::hid::Controller*>::iterator it = m_pControllerList.begin();
            it != m_pControllerList.end();
            ++it
            )
        {
            if ((*it))
            {
                delete (*it);
                (*it) = nullptr;
            }
        }
        m_pConnectedControllerList.clear();
    }

    void ControllerManager::Update() NN_NOEXCEPT
    {
        // 一旦内容をクリアします
        m_pConnectedControllerList.clear();

        // 全てのコントローラを更新します
        for (
            std::vector<nns::hidfw::hid::Controller*>::iterator it = m_pControllerList.begin();
            it != m_pControllerList.end();
            ++it
            )
        {
            (*it)->Update();
            if ((*it)->isConnected())
            {
                // 接続中のコントローラを追加します
                m_pConnectedControllerList.push_back((*it));
            }
        }
    }

    ControllerManager& ControllerManager::GetInstance() NN_NOEXCEPT
    {
        static ControllerManager instance;
        return instance;
    }

    int ControllerManager::GetControllerListSize() NN_NOEXCEPT
    {
        return m_pControllerList.size();
    }

    int ControllerManager::GetConnectedControllerListSize() NN_NOEXCEPT
    {
        return m_pConnectedControllerList.size();
    }

    std::vector<nns::hidfw::hid::Controller*>& ControllerManager::GetControllerList() NN_NOEXCEPT
    {
        return m_pControllerList;
    }

    std::vector<nns::hidfw::hid::Controller*>& ControllerManager::GetConnectedControllerList() NN_NOEXCEPT
    {
        return m_pConnectedControllerList;
    }

    Controller* ControllerManager::GetControllerFromIndex(int index) NN_NOEXCEPT
    {
        if (index >= static_cast<int>(m_pControllerList.size()))
        {
            return nullptr;
        }
        return m_pControllerList.at(index);
    }

    Controller* ControllerManager::GetController(nn::hid::NpadIdType npadId) NN_NOEXCEPT
    {
        for (
            std::vector<nns::hidfw::hid::Controller*>::iterator it = m_pControllerList.begin();
            it != m_pControllerList.end();
            ++it
            )
        {
            if ((*it)->GetNpadId() == npadId)
            {
                return (*it);
            }
        }
        return nullptr;
    }

    Controller* ControllerManager::GetConnectedControllerFromIndex(int index) NN_NOEXCEPT
    {
        if (index >= static_cast<int>(m_pConnectedControllerList.size()))
        {
            return nullptr;
        }
        return m_pConnectedControllerList.at(index);
    }

    Controller* ControllerManager::GetConnectedController(nn::hid::NpadIdType npadId) NN_NOEXCEPT
    {
        for (
            std::vector<nns::hidfw::hid::Controller*>::iterator it = m_pConnectedControllerList.begin();
            it != m_pConnectedControllerList.end();
            ++it
            )
        {
            if ((*it)->GetNpadId() == npadId)
            {
                return (*it);
            }
        }
        return nullptr;
    }

    ControllerManager::ControllerManager() NN_NOEXCEPT
    {

    }

}}}
