﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/rid.h>
#include <nn/result/result_HandlingUtility.h>
#include "DevQuestMenu_PrepareModeScene.h"
#include "../DevQuestMenu_Log.h"

namespace nn { namespace devquestmenu {
    namespace {
        const char* ToString(rid::ControllerUpdateProgress::State state)
        {
            switch (state)
            {
            case rid::ControllerUpdateProgress::State::DoNothing:
                return "DoNothing";
            case rid::ControllerUpdateProgress::State::Applying:
                return "Applying";
            case rid::ControllerUpdateProgress::State::Completed:
                return "Completed";
            case rid::ControllerUpdateProgress::State::Failed:
                return "Failed";
            case rid::ControllerUpdateProgress::State::NeedNoUpdate:
                return "NeedNoUpdate";
            case rid::ControllerUpdateProgress::State::Cancelled:
                return "Cancelled";
            default:
                break;
            }
        }
    }

    PrepareModeScene::PrepareModeScene(RootSurfaceContext* pRootSurface) NN_NOEXCEPT
        : ModeSceneCommon("Prepare Mode", pRootSurface)
    {
        // 試遊準備モードで行う処理
        // 時間がかかる可能性もあるので、コンストラクタで行わないほうがよいがとりあえず
        NN_ABORT_UNLESS_RESULT_SUCCESS(rid::CheckContentsIntegrity());
        NN_ABORT_UNLESS_RESULT_SUCCESS(rid::DeleteAllMii());
        NN_ABORT_UNLESS_RESULT_SUCCESS(rid::DeleteAllAlbums());

        // コントローラ FW 更新
        rid::ControllerUpdater updater;
        Result result = updater.Execute();
        if (result.IsSuccess())
        {
            QUESTMENU_LOG("ControllerUpdate has been succeeded. Last state is \"%s\".\n", ToString(updater.GetProgress().state));
        }
        else
        {
            QUESTMENU_LOG("ControllerUpdate is failed as result 0x%08x. Last state is \"%s\".\n", result.GetInnerValueForDebug(), ToString(updater.GetProgress().state));
        }

        //! アプリケーション更新中フラグを降ろす
        m_pRootSurface->SetApplicationUpdating(false);
    };

    void PrepareModeScene::OnLoop() NN_NOEXCEPT
    {
    };

    ModeType PrepareModeScene::DetermineNextMode(const DisplayModeTime& displayModeTime) NN_NOEXCEPT
    {
        if (displayModeTime.IsDuringDisplayModeTime())
        {
            m_pRootSurface->SaveSettingsAndReboot(); //! 試遊モード時間内ならば本体再起動
            return ModeType_NonChange;
        }
        else
        {
            return ModeType_SleepMode; //! 試遊モード時間外ならば Sleep
        }
    };

    ModeType PrepareModeScene::GetSuccessNextMode() NN_NOEXCEPT
    {
        return ModeType_SleepMode;
    };
}}
