﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include "../common.h"
#include "../DevQuestMenu_LabelButton.h"
#include "../DevQuestMenu_DisplayModeTime.h"
#include "../DevQuestMenu_ModeType.h"
#include "../DevQuestMenu_RootSurface.h"

namespace nn { namespace devquestmenu {

    class RootSurfaceContext; //! RootSurface, ModeSceneCommon 相互参照用の前方宣言

    class ModeSceneCommon : public glv::View
    {
    public:

        /**
         * @brief       モードごとで定期的に実行される処理
         *
         */
        virtual void OnLoop() NN_NOEXCEPT = 0;

        /**
         * @brief       次に遷移するモードを決定する処理
         *
         * @param[in]   displayModeTime     設定された更新開始時間
         */
        virtual ModeType DetermineNextMode(const DisplayModeTime& displayModeTime) NN_NOEXCEPT = 0;

        /**
        * @brief       成功した場合の次モードに強制遷移させます(デバッグ用)
        *
        */
        virtual ModeType GetSuccessNextMode() NN_NOEXCEPT = 0;

        const char* GetCaption() NN_NOEXCEPT { return m_ModeCaption; }

        virtual void RegisterDebugButton(glv::ViewContainer* pContainer) NN_NOEXCEPT {};

    protected:
        const char* m_ModeCaption;
        RootSurfaceContext* m_pRootSurface;
        float m_GridWidth;
        float m_GridHeight;

        ModeSceneCommon(const char* caption, RootSurfaceContext* pRootSurface) NN_NOEXCEPT;

        /**
         * @brief       ラベルを作成します
         *
         * @param[in]   label       表示
         * @param[in]   spec        位置
         */
        std::unique_ptr<glv::Label> MakeLabel(const std::string& label, const glv::Label::Spec& spec) NN_NOEXCEPT;
        std::unique_ptr<glv::Label> MakeLabel(glv::ViewContainer* pContainer, const std::string& label, const glv::Label::Spec& spec) NN_NOEXCEPT;

        /**
         * @brief       ボタンを作成します
         *
         * @param[in]   label       表示
         * @param[in]   callback    実行される関数
         * @param[in]   r           位置・大きさ
         */
        std::unique_ptr<LabelButton> MakeLabelButton(const std::string& label, std::function< void() > callback, const glv::Rect& r) NN_NOEXCEPT;
        std::unique_ptr<LabelButton> MakeLabelButton(glv::ViewContainer* pContainer, const std::string& label, std::function< void() > callback, const glv::Rect& r) NN_NOEXCEPT;
    };
}}
