﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

namespace nn { namespace devquestmenu {

    class RidFileIo
    {
    public:

        /**
         * @brief       file を読み込みます
         *
         * @param[out]  pBuffer     バッファ
         * @param[in]   bufferSize  バッファサイズ
         * @param[in]   filePath    ファイルパス
         */
        static bool ReadFile(nn::Bit8* pBuffer, int bufferSize, const char* filePath) NN_NOEXCEPT;
    };
}}
