﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <glv.h>
#include <glv_binding.h>

namespace nn { namespace devquestmenu {

    class LabelButton : public glv::Button
    {
    public:
        LabelButton(const char* caption, std::function< void() > callback, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
        void Initialize() NN_NOEXCEPT;
        void ChangeCaption(const char* caption) NN_NOEXCEPT;

    private:
        glv::Label m_Label;                 //! ボタンのラベル
        std::function<void()> m_Callback;   //! ボタンを押した時に呼び出される関数
    };
}}
