﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "DevQuestMenu_LabelButton.h"

namespace
{
    static const float InitialFontSize = 25.f;  //! 既定のフォントサイズ
}

namespace nn { namespace devquestmenu {

    LabelButton::LabelButton(const char* caption, std::function< void() > callback, const glv::Rect& r, glv::Place::t anchor) NN_NOEXCEPT
        : glv::Button(r, true)
        , m_Label(caption, glv::Label::Spec(glv::Place::CC, 0.0f, 0.0f, InitialFontSize))
        , m_Callback(callback)
    {
        this->disable(glv::Property::FocusToTop);
        this->anchor(anchor);
        Initialize();
    }

    void LabelButton::Initialize() NN_NOEXCEPT
    {
        *this << m_Label;
        changePadClickDetectableButtons(glv::BasicPadEventType::Button::Ok::Mask);
        changePadClickDetectableButtons(glv::DebugPadEventType::Button::Ok::Mask);
        attach([](const glv::Notification& n)->void { n.receiver< LabelButton >()->m_Callback(); }, glv::Update::Clicked, this);
    }

    void LabelButton::ChangeCaption(const char* caption) NN_NOEXCEPT
    {
        m_Label.setValue(caption);
    }
}}
