﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <cstring>
#include "common.h"
#include "DevQuestMenu_RapidJsonConfig.h"

// Siglo 環境での警告抑止用
#if defined(NN_BUILD_CONFIG_OS_WIN32)
#pragma warning(push)
#pragma warning(pop)
#pragma warning(disable : 4244)
#pragma warning(disable : 4668)
#pragma warning(disable : 4702)
#endif
#include <rapidjson/document.h>

namespace nn { namespace devquestmenu {

    struct CountryBasisString
    {
        std::string jpJapanese;
        std::string usEnglish;
        std::string usFrench;
        std::string usSpanish;
        std::string euEnglish;
    };

    struct Rating
    {
        std::string ratingBoard;
        int ratingValue;
        bool isRatingPending;
        std::vector<CountryBasisString> ratingDescripterList;
    };

    class AssetMeta
    {
    private:
        void InitializeAssetMeta(const char* buffer) NN_NOEXCEPT;
        std::string m_JsonFormat;   //! Json Text

    public:
        explicit AssetMeta(const char* buffer) NN_NOEXCEPT;

        /**
         * @brief       AssetMeta の値をログに表示します。
         */
        void LogOutAssetMetaValue() NN_NOEXCEPT;

        /**
         * @brief       AssetMeta に設定された Application ID の Application を起動します。
         */
        void LaunchApplication(bool isLaunchDelayed) NN_NOEXCEPT;

        /**
         * @brief       体験版アプリの起動を 40 秒遅延させます（デバッグ用）
         */
        void DelayLaunch() NN_NOEXCEPT;

        int m_Index;                                        //! インデックス
        int m_Version;                                      //! バージョン
        std::string m_AocApplicationId;                     //! Aoc の Application ID
        std::string m_DemoApplicationId;                    //! Demo の Application ID
        CountryBasisString m_Title;                         //! タイトル名
        std::vector<std::string> m_CategoryList;            //! カテゴリ
        CountryBasisString m_Box;                           //! パッケージ画像
        CountryBasisString m_Movie;                         //! PV
        CountryBasisString m_Description;                   //! 説明
        CountryBasisString m_Publisher;                     //! 出版社
        CountryBasisString m_Developer;                     //! 開発社
        CountryBasisString m_ReleaseDate;                   //! リリース日
        CountryBasisString m_Price;                         //! 価格
        bool m_IsTvMultiPlayerSupported;                    //! マルチプレイヤーをサポートするか(TVモード)
        bool m_IsTabletopMultiPlayerSupported;              //! マルチプレイヤーをサポートするか(Tabletopモード)
        bool m_IsHandheldMultiPlayerSupported;              //! マルチプレイヤーをサポートするか(Handheldモード)
        std::vector<std::string> m_SuppurtedControllerList; //! サポートするコントローラーのリスト
        bool m_IsMovieOnly;                                 //! PV のみのコンテンツ
        uint32_t m_GamePlayTimer;                           //! プレイ可能時間 (0 の場合は制限時間なし)
        std::vector<Rating> m_RatingList;                   //! レーティングリスト
    };
}}

