﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_IMenuItem.h"

namespace ui{ namespace util{

    class ProcessUpdatePanel
    {
    public:

        static void Update(const std::shared_ptr<IMenuItem>& pItem) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return;
            }

            // BackgroundStyle_InnerItem のため先に子孫を更新する
            int n = pItem->GetChildCount();
            for(int i = 0; i < n; i++)
            {
                Update(pItem->GetChild(i));
            }

            pItem->UpdatePanel();
        }
    };

}}
