﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_IMenuItem.h"

namespace ui{ namespace util{

    class ProcessTouchHandling
    {
    public:
        static MenuButtonResult HandleTouched(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT
        {
            if(pItem && pItem->IsEnabled())
            {
                return pItem->HandleTouched(context, position);
            }
            return MenuButtonResult::GetNotHandled();
        }

        static MenuButtonResult HandleTouchDown(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT
        {
            if(pItem && pItem->IsEnabled())
            {
                return pItem->HandleTouchDown(context, position);
            }
            return MenuButtonResult::GetNotHandled();
        }

        static MenuButtonResult HandleTouchUp(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT
        {
            if(pItem && pItem->IsEnabled())
            {
                return pItem->HandleTouchUp(context, position);
            }
            return MenuButtonResult::GetNotHandled();
        }

        static MenuButtonResult HandleTouchMove(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT
        {
            if(pItem && pItem->IsEnabled())
            {
                return pItem->HandleTouchMove(context, position);
            }
            return MenuButtonResult::GetNotHandled();
        }

        static MenuButtonResult HandleTouchCanceled(const std::shared_ptr<IMenuItem>& pItem) NN_NOEXCEPT
        {
            if(pItem && pItem->IsEnabled())
            {
                return pItem->HandleTouchCanceled();
            }
            return MenuButtonResult::GetNotHandled();
        }
    };

}}
