﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_IMenuItem.h"

namespace ui{ namespace util{

    class ProcessLoadStoreValue
    {
    public:
        static void Load(const std::shared_ptr<IMenuItem>& pItem, const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return;
            }

            pItem->LoadValue(pPage);

            int n = pItem->GetChildCount();
            for(int i = 0; i < n; i++)
            {
                Load(pItem->GetChild(i), pPage);
            }
        }

        static void Store(const std::shared_ptr<IMenuItem>& pItem) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return;
            }

            pItem->StoreValue();

            int n = pItem->GetChildCount();
            for(int i = 0; i < n; i++)
            {
                Store(pItem->GetChild(i));
            }
        }
    };

}}
