﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_IMenuItem.h"

namespace ui{ namespace util{

    class ProcessAnalogStickHandling
    {
    public:
        static MenuButtonResult HandleLeftAnalogStickInput(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context, const nn::util::Vector3f& value) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return MenuButtonResult::GetNotHandled();
            }

            MenuButtonResult result = MenuButtonResult::GetNotHandled();
            if(pItem->IsEnabled())
            {
                result = pItem->HandleLeftAnalogStickInput(context, value);
            }

            if(!result.IsHandled())
            {
                if(auto pParent = pItem->GetParentInfo().pParent.lock())
                {
                    auto innerContext = MenuButtonHandleContext::CreateNextContext(pItem, context);
                    return HandleLeftAnalogStickInput(pParent, innerContext, value);
                }
            }
            return result;
        }

        static MenuButtonResult HandleRightAnalogStickInput(const std::shared_ptr<IMenuItem>& pItem, const MenuButtonHandleContext& context, const nn::util::Vector3f& value) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return MenuButtonResult::GetNotHandled();
            }

            MenuButtonResult result = MenuButtonResult::GetNotHandled();
            if(pItem->IsEnabled())
            {
                result = pItem->HandleRightAnalogStickInput(context, value);
            }

            if(!result.IsHandled())
            {
                if(auto pParent = pItem->GetParentInfo().pParent.lock())
                {
                    auto innerContext = MenuButtonHandleContext::CreateNextContext(pItem, context);
                    return HandleRightAnalogStickInput(pParent, innerContext, value);
                }
            }
            return result;
        }

    };

}}
