﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ui_CalculateTextSize.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../../framework/Framework.h"

namespace ui{ namespace util{

    Size CalculateTextSize::Calculate(const char* text, float fontSize, int usage) NN_NOEXCEPT
    {
        int w = 0;
        int h = 0;
        Framework::CalculateTextRenderingSize(&w, &h, text, fontSize, static_cast<framework::TextWriterUsage>(usage));

        return {w, h};
    }

}}
