﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../../panel/panel_IPanel.h"
#include "../ui_StyleTypes.h"
#include "../ui_IMenuItem.h"

namespace ui{ namespace util{

    class CalculateBackgroundVisibility
    {
    public:
        struct Value
        {
            panel::PanelVisibility visibility;
            nn::util::Color4f color;
        };

    public:
        static Value Calculate(const BackgroundStyle& style, const std::shared_ptr<IMenuItem>& pInnerItem) NN_NOEXCEPT
        {
            return Calculate(style, pInnerItem ? pInnerItem->GetPanel() : nullptr);
        }

        static Value Calculate(const BackgroundStyle& style, const std::shared_ptr<panel::IPanel>& pInnerPanel) NN_NOEXCEPT
        {
            Value value = {};
            switch(style.GetMode())
            {
            case ui::BackgroundMode_Color:
                {
                    value.visibility = panel::PanelVisibility::Visible;
                    value.color = style.GetColor();
                    break;
                }
            case ui::BackgroundMode_InnerItem:
                {
                    if(pInnerPanel)
                    {
                        value.visibility = pInnerPanel->GetVisibility();
                        value.color = pInnerPanel->GetColor();
                        break;
                    }
                    else
                    {
                        value.visibility = panel::PanelVisibility::Transparent;
                        break;
                    }
                }
            default:
                // Transparent
                {
                    value.visibility = panel::PanelVisibility::Transparent;
                }
            }

            return value;
        }
    };

}}
