﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <vector>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace ui{

    class IMenuPage;
    class RadioButton;

    class RadioButtonGroup
    {
        friend class RadioButton;
    public:
        // RadioButton::NotifySelectedStateChanged() で通知する。
        void SetSelectedItem(const std::shared_ptr<RadioButton>& item, const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT;

        // 選択されているアイテムを取得する。
        // 選択されているものがない場合 nullptr を返す。
        std::shared_ptr<RadioButton> GetSelectedItem() const NN_NOEXCEPT;

    private:
        std::weak_ptr<RadioButton> m_SelectedItem;
    };

}
