﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ui_RadioButtonGroup.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "ui_RadioButton.h"

namespace ui{

    void RadioButtonGroup::SetSelectedItem(const std::shared_ptr<RadioButton>& item, const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT
    {
        auto prevItem = m_SelectedItem.lock();
        if(prevItem == item)
        {
            return;
        }

        m_SelectedItem = item;

        if(prevItem)
        {
            prevItem->NotifySelectedStateChanged(false, pPage);
        }

        if(item)
        {
            item->NotifySelectedStateChanged(true, pPage);
        }
    }

    std::shared_ptr<RadioButton> RadioButtonGroup::GetSelectedItem() const NN_NOEXCEPT
    {
        return m_SelectedItem.lock();
    }


}

