﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../panel/panel_PanelText.h"
#include "base/ui_MenuItemBase.h"
#include "base/ui_MenuItemAttributeLeafItem.h"
#include "base/ui_MenuItemAttributeTraceFocusState.h"
#include "base/ui_MenuItemStyleProperty.h"

#include "ui_RadioButton.h"
#include "ui_RadioButtonGroup.h"

namespace ui{

    class MenuItemRadioButtonStyle
        : public
            base::MenuItemStylePropertySizeStyle<base::StateNone,
            base::MenuItemStylePropertyMargin<base::StateNone,
            base::MenuItemStylePropertyAlignment<base::StateNone,
            base::MenuItemStylePropertyBackgroundColor<base::StateEnablityFocusSelection,
            base::MenuItemStylePropertyTextStyle<base::StateEnablityFocusSelection,
            base::MenuItemStyleBase<MenuItemRadioButtonStyle>
            >>>>>
    {
    };

    class MenuItemRadioButton
        : public  base::MenuItemAttributeTraceFocusState
                < base::MenuItemAttributeLeafItem
                < base::MenuItemBase<IMenuItem, MenuItemRadioButton>
                >>
    {
    private:
        enum SelectionState
        {
            SelectionState_Unspecified = 0,
            SelectionState_NotSelected,
            SelectionState_Selected,
        };

    public:
        MenuItemRadioButton(const MenuItemRadioButtonStyle& style, std::shared_ptr<RadioButtonGroup>& group, const std::string& text) NN_NOEXCEPT;
        ~MenuItemRadioButton() NN_NOEXCEPT;

        std::shared_ptr<MenuItemRadioButton> SetValueAccessor(const std::function<bool ()>& getter, const std::function<void (bool)>& setter) NN_NOEXCEPT;
        std::shared_ptr<MenuItemRadioButton> SetValueChangedCallbackFunction(const std::function<void (bool, const std::shared_ptr<IMenuPage>&)>& f) NN_NOEXCEPT;
        bool IsSelected() const NN_NOEXCEPT;

        // Geometry
        virtual void UpdateLayoutRecursively(const MenuLayoutUpdateContext& context) NN_NOEXCEPT UI_FINAL;

        // Focus/Touch
        virtual bool IsFocusAcceptable() const NN_NOEXCEPT UI_FINAL;
        virtual bool IsTouchAcceptable() const NN_NOEXCEPT UI_FINAL;

        // User Input
        virtual MenuButtonResult HandlePositiveButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT UI_FINAL;
        virtual MenuButtonResult HandleTouched(const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT UI_FINAL;

        // Load/Store Value
        virtual void LoadValue(const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT UI_FINAL;
        virtual void StoreValue() const NN_NOEXCEPT UI_FINAL;

        // Rendering
        virtual std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT UI_FINAL;
        virtual void UpdatePanel() NN_NOEXCEPT UI_FINAL;

    private:
        void SetStyleImpl(const MenuItemRadioButtonStyle& style) NN_NOEXCEPT;
        void SetSelectedImpl(bool value, const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT; // このアイテムから RadioButton に通知する
        void NotifyValueChangedImpl(bool value, const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT; // RadioButton からこのアイテムに通知する

    protected:
        std::shared_ptr<panel::PanelText> m_pPanel;
        std::shared_ptr<RadioButton> m_pRadioButton;
        MenuItemRadioButtonStyle m_Style;
        SelectionState m_SelectionState = SelectionState_Unspecified;
        Position m_TextPosition;

        std::function<bool ()> m_ValueLoadFunction;
        std::function<void (bool)> m_ValueStoreFunction;
        std::function<void (bool, const std::shared_ptr<IMenuPage>&)> m_ValueChangedCallbackFunction;
    };

}
