﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../panel/panel_PanelContainer.h"
#include "../panel/panel_PanelText.h"
#include "base/ui_MenuItemBase.h"
#include "base/ui_MenuItemAttributeLeafItem.h"
#include "base/ui_MenuItemAttributeTraceFocusState.h"
#include "base/ui_MenuItemStyleProperty.h"

#include "ui_MenuItemColumn.h"
#include "ui_RadioButtonGroup.h"

namespace ui{
    class MenuItemDropDownListEntry;

    class MenuItemDropDownPopupStyle
        : public
            base::MenuItemStylePropertyRegion<base::StateNone,
            base::MenuItemStylePropertyHorizontalScrollbarStyle<base::StateNone,
            base::MenuItemStylePropertyVerticalScrollbarStyle<base::StateNone,
            base::MenuItemStylePropertyArrowButtonScrollDistance<base::StateNone,
            base::MenuItemStylePropertyAnalogStickScrollDistanceMax<base::StateNone,
            base::MenuItemStyleBase<MenuItemDropDownPopupStyle>
            >>>>>
    {
    };

    namespace base{
        UI_ITEMSTYLEPROP_STATE_DEFINE(MenuItemDropDownPopupStyle, DropDownPopupStyle);
    }

    class MenuItemDropDownListStyle
        : public
            base::MenuItemStylePropertySizeStyle<base::StateNone,
            base::MenuItemStylePropertyMargin<base::StateNone,
            base::MenuItemStylePropertyAlignment<base::StateNone,
            base::MenuItemStylePropertyDropDownPopupStyle<base::StateNone,
            base::MenuItemStylePropertyBackgroundColor<base::StateEnablityFocusSelection,
            base::MenuItemStylePropertyTextStyle<base::StateEnablityFocusSelection,
            base::MenuItemStyleBase<MenuItemDropDownListStyle>
            >>>>>>
    {
    };

    class MenuItemDropDownList
        : public  base::MenuItemAttributeTraceFocusState
                < base::MenuItemAttributeLeafItem   // ポップアップは別レイヤとして作られるのでこのアイテム自身は葉ノード
                < base::MenuItemBase<IMenuItem, MenuItemDropDownList>
                >>
    {
        friend class MenuItemDropDownListEntry;
    public:
        explicit MenuItemDropDownList(const MenuItemDropDownListStyle& style) NN_NOEXCEPT;

        std::shared_ptr<MenuItemDropDownList> AddDropDownItem(
            const std::string& name,
            const std::function<bool ()>& getter,
            const std::function<void (bool)>& setter,
            const std::function<void (bool, const std::shared_ptr<IMenuPage>&)>& valueChangedCallback
        ) NN_NOEXCEPT;

        // Geometry
        virtual void UpdateLayoutRecursively(const MenuLayoutUpdateContext& context) NN_NOEXCEPT UI_FINAL;

        // Focus/Touch
        virtual bool IsFocusAcceptable() const NN_NOEXCEPT UI_FINAL;
        virtual bool IsTouchAcceptable() const NN_NOEXCEPT UI_FINAL;

        // UserInput
        virtual MenuButtonResult HandlePositiveButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT UI_FINAL;
        virtual MenuButtonResult HandleTouched(const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT UI_FINAL;

        // Load/Store Value
        virtual void LoadValue(const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT UI_FINAL;
        virtual void StoreValue() const NN_NOEXCEPT UI_FINAL;

        // Rendering
        virtual std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT UI_FINAL;
        virtual void UpdatePanel() NN_NOEXCEPT UI_FINAL;

    private:
        void PushSelectionLayerImpl(const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT;
        void NotifyEntrySelectionStateChanged(int index, bool isSelected) NN_NOEXCEPT;

    protected:
        MenuItemDropDownListStyle m_Style;

        std::shared_ptr<panel::PanelContainer> m_pPanelContainer;
        std::shared_ptr<panel::PanelText> m_pPanelText;

        std::shared_ptr<MenuItemColumn> m_pListTable;
        std::shared_ptr<RadioButtonGroup> m_pListEntryGroup;

        struct EntryInfo
        {
            std::shared_ptr<MenuItemDropDownListEntry> m_pEntry;
            Position m_TextPosition = {};
        };
        std::vector<EntryInfo> m_EntryList;

        int m_SelectedEntryIndex = -1;
    };

}
