﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_Types.h"
#include "../ui_StyleTypes.h"
#include "../ui_ItemStateFilter.h"
#include "ui_ItemState.h"

namespace ui{ namespace base{
    extern void* enabler;

    template<typename TConcreteType>
    class MenuItemStyleBase
    {
    public:
        typedef TConcreteType ConcreteType;

    public:
        virtual ~MenuItemStyleBase() NN_NOEXCEPT {}
    };

#define UI_ITEMSTYLEPROP_STATE_I(ValueType, Name, StateType, GetterArgDecl, GetterArgCall) \
    template<typename BaseType>                                 \
    class MenuItemStyleProperty##Name<StateType, BaseType>      \
        : public BaseType                                       \
    {                                                           \
    public:                                                     \
        typedef typename BaseType::ConcreteType ConcreteType;   \
        typedef std::conditional<std::is_fundamental<ValueType>::value, ValueType, const ValueType&>::type ArgType;   \
    public:                                                     \
        ConcreteType& Set##Name(ArgType value) NN_NOEXCEPT      \
        {                                                       \
            Set##Name(ItemStateFilter_Any, value);              \
            return reinterpret_cast<ConcreteType&>(*this);      \
        }                                                       \
                                                                \
        ConcreteType& Set##Name(ItemStateFilterType filter, ArgType value) NN_NOEXCEPT \
        {                                                       \
            m_##Name.SetValue(filter, value, 0);                \
            return reinterpret_cast<ConcreteType&>(*this);      \
        }                                                       \
                                                                \
        ValueType Get##Name GetterArgDecl const NN_NOEXCEPT     \
        {                                                       \
            return m_##Name.GetValue GetterArgCall;             \
        }                                                       \
                                                                \
    private:                                                    \
        ItemStatedValue<ValueType, StateType> m_##Name;         \
    };

#define UI_ITEMSTYLEPROP_STATE_NONE(ValueType, Name)    \
    UI_ITEMSTYLEPROP_STATE_I(ValueType, Name, StateNone, (), ())
#define UI_ITEMSTYLEPROP_STATE_ENABLITY(ValueType, Name)    \
    UI_ITEMSTYLEPROP_STATE_I(ValueType, Name, StateEnablity, (bool isEnabled), (isEnabled))
#define UI_ITEMSTYLEPROP_STATE_ENABLITY_FOCUS(ValueType, Name)  \
    UI_ITEMSTYLEPROP_STATE_I(ValueType, Name, StateEnablityFocus, (bool isEnabled, bool isFocused), (isEnabled, isFocused))
#define UI_ITEMSTYLEPROP_STATE_ENABLITY_FOCUS_SELECTION(ValueType, Name)    \
    UI_ITEMSTYLEPROP_STATE_I(ValueType, Name, StateEnablityFocusSelection, (bool isEnabled, bool isFocused, bool isSelected), (isEnabled, isFocused, isSelected))

#define UI_ITEMSTYLEPROP_STATE_DEFINE(ValueType, Name)  \
    template<typename TState, typename BaseType>        \
    class MenuItemStyleProperty##Name;                  \
    UI_ITEMSTYLEPROP_STATE_NONE(ValueType, Name)        \
    UI_ITEMSTYLEPROP_STATE_ENABLITY(ValueType, Name)       \
    UI_ITEMSTYLEPROP_STATE_ENABLITY_FOCUS(ValueType, Name)       \
    UI_ITEMSTYLEPROP_STATE_ENABLITY_FOCUS_SELECTION(ValueType, Name)


    UI_ITEMSTYLEPROP_STATE_DEFINE(ItemAlignment, Alignment);
    UI_ITEMSTYLEPROP_STATE_DEFINE(Margin, Margin);
    UI_ITEMSTYLEPROP_STATE_DEFINE(SizeStyle, SizeStyle);
    UI_ITEMSTYLEPROP_STATE_DEFINE(nn::util::Color4f, BackgroundColor);
    UI_ITEMSTYLEPROP_STATE_DEFINE(BackgroundStyle, BackgroundStyle);
    UI_ITEMSTYLEPROP_STATE_DEFINE(BorderStyle, BorderStyle);
    UI_ITEMSTYLEPROP_STATE_DEFINE(TextStyle, TextStyle);
    UI_ITEMSTYLEPROP_STATE_DEFINE(IconStyle, IconStyle);
    UI_ITEMSTYLEPROP_STATE_DEFINE(ScrollbarStyle, HorizontalScrollbarStyle);
    UI_ITEMSTYLEPROP_STATE_DEFINE(ScrollbarStyle, VerticalScrollbarStyle);
    UI_ITEMSTYLEPROP_STATE_DEFINE(CheckMarkStyle, CheckMarkStyle);
    UI_ITEMSTYLEPROP_STATE_DEFINE(int, ArrowButtonScrollDistance);
    UI_ITEMSTYLEPROP_STATE_DEFINE(int, AnalogStickScrollDistanceMax);
    UI_ITEMSTYLEPROP_STATE_DEFINE(Rectangle, Region);

}}
