﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_Macro.h"
#include "../ui_IMenuItem.h"
#include "../../Config.h"

namespace ui{ namespace base{

    // フォーカスを受け取らないアイテム
    template<typename TBaseType>
    class MenuItemAttributeNoFocus
        : public TBaseType
    {
    public:
        typedef typename TBaseType::ConcreteType ConcreteType;

    public:
        virtual bool IsFocusAcceptable() const NN_NOEXCEPT UI_FINAL
        {
            return false;
        }

        virtual void OnInFocus() NN_NOEXCEPT UI_FINAL
        {
        }

        virtual void OnOutFocus() NN_NOEXCEPT UI_FINAL
        {
        }
    };

}}
