﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_Macro.h"
#include "../ui_IMenuItem.h"

namespace ui{ namespace base{

    // スティック入力に対してユーザーが設定したコールバックを呼び出す。
    //
    // スティック入力はフォーカスを得ているアイテムが処理しなかった場合、親アイテムに伝搬される。
    template<typename TBaseType>
    class MenuItemAttributeAnalogStickInputCallback
        : public TBaseType
    {
    public:
        typedef typename TBaseType::ConcreteType ConcreteType;

    public:
        virtual MenuButtonResult HandleLeftAnalogStickInput(const MenuButtonHandleContext&, const nn::util::Vector3f& value) NN_NOEXCEPT UI_FINAL
        {
            if(m_OnLeftAnalogStickInputCallbackFunction)
            {
                m_OnLeftAnalogStickInputCallbackFunction(value);
                return MenuButtonResult::GetHandled();
            }
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleRightAnalogStickInput(const MenuButtonHandleContext&, const nn::util::Vector3f& value) NN_NOEXCEPT UI_FINAL
        {
            if(m_OnRightAnalogStickInputCallbackFunction)
            {
                m_OnRightAnalogStickInputCallbackFunction(value);
                return MenuButtonResult::GetHandled();
            }
            return MenuButtonResult::GetNotHandled();
        }

        std::shared_ptr<ConcreteType> SetLeftAnalogStickInputCallbackFunction(const std::function<void (const nn::util::Vector3f&)>& value) NN_NOEXCEPT
        {
            m_OnLeftAnalogStickInputCallbackFunction = value;
            return this->shared_from_this();
        }

        std::shared_ptr<ConcreteType> SetRightAnalogStickInputCallbackFunction(const std::function<void (const nn::util::Vector3f&)>& value) NN_NOEXCEPT
        {
            m_OnRightAnalogStickInputCallbackFunction = value;
            return this->shared_from_this();
        }

    private:
        std::function<void (const nn::util::Vector3f&)> m_OnLeftAnalogStickInputCallbackFunction;
        std::function<void (const nn::util::Vector3f&)> m_OnRightAnalogStickInputCallbackFunction;
    };

}}
