﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationServerMaintenance.h"

#include <nn/util/util_FormatString.h>
#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationServerMaintenance::NotificationServerMaintenance() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetServerMaintenanceTextColor());
        m_pPanel->SetTextPosition(Style::GetServerMaintenanceTextPositionX(), Style::GetServerMaintenanceTextPositionY());
        m_pPanel->SetTextSize(Style::GetServerMaintenanceTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationServerMaintenance::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationServerMaintenance::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationServerMaintenance::SetupScheduled() NN_NOEXCEPT
    {
        m_pPanel->SetText("Server maintenance is scheduled");

        m_TimeToLive = config::NotificationTtl::GetTtlServerMaintenanceNotice();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_ServerMaintenanceNotice;
        return true;
    }

    bool NotificationServerMaintenance::SetupStart() NN_NOEXCEPT
    {
        m_pPanel->SetText("Starting server maintenance");

        m_TimeToLive = config::NotificationTtl::GetTtlServerMaintenanceStart();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_ServerMaintenanceStart;
        return true;
    }
}}
