﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationScreenShot.h"

#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    enum Priority
    {
        Priority_Highest = 0,
        Priority_ResultError,
        Priority_ResultSuccess,
        Priority_Progress,
        Priority_Lowest,
    };

    NotificationScreenShot::NotificationScreenShot() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetScreenShotTextColor());
        m_pPanel->SetTextPosition(Style::GetScreenShotTextPositionX(), Style::GetScreenShotTextPositionY());
        m_pPanel->SetTextSize(Style::GetScreenShotTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationScreenShot::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationScreenShot::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationScreenShot::SetupSuccess() NN_NOEXCEPT
    {
        m_pPanel->SetText("ScreenShot ... Saved");

        m_TimeToLive = config::NotificationTtl::GetTtlScreenShotSuccess();
        m_Category   = NotificationCategory_ScreenShot;
        m_Priority   = Priority_ResultSuccess;
        return true;
    }
    bool NotificationScreenShot::SetupFailure() NN_NOEXCEPT
    {
        m_pPanel->SetText("ScreenShot ... Error");

        m_TimeToLive = config::NotificationTtl::GetTtlScreenShotFailure();
        m_Category   = NotificationCategory_ScreenShot;
        m_Priority   = Priority_ResultError;
        return true;
    }
    bool NotificationScreenShot::SetupProhibited() NN_NOEXCEPT
    {
        m_pPanel->SetText("ScreenShot ... Prohibited");

        m_TimeToLive = config::NotificationTtl::GetTtlScreenShotFailure();
        m_Category   = NotificationCategory_ScreenShot;
        m_Priority   = Priority_ResultError;
        return true;
    }
    bool NotificationScreenShot::SetupAlbumIsFull() NN_NOEXCEPT
    {
        m_pPanel->SetText("ScreenShot ... Error(AlbumFull)");

        m_TimeToLive = config::NotificationTtl::GetTtlScreenShotFailure();
        m_Category   = NotificationCategory_ScreenShot;
        m_Priority   = Priority_ResultError;
        return true;
    }
    bool NotificationScreenShot::SetupAlbumFileCountLimit() NN_NOEXCEPT
    {
        m_pPanel->SetText("ScreenShot ... Error(AlbumLimit)");

        m_TimeToLive = config::NotificationTtl::GetTtlScreenShotFailure();
        m_Category   = NotificationCategory_ScreenShot;
        m_Priority   = Priority_ResultError;
        return true;
    }
    bool NotificationScreenShot::SetupThumbnailIsReady() NN_NOEXCEPT
    {
        m_pPanel->SetText("ScreenShot ...");

        m_TimeToLive = config::NotificationTtl::GetTtlScreenShotSuccess();
        m_Category   = NotificationCategory_ScreenShot;
        m_Priority   = Priority_Progress;
        return true;
    }
    bool NotificationScreenShot::SetupFileSystemError() NN_NOEXCEPT
    {
        m_pPanel->SetText("ScreenShot ... Error(FileSystem)");

        m_TimeToLive = config::NotificationTtl::GetTtlScreenShotFailure();
        m_Category   = NotificationCategory_ScreenShot;
        m_Priority   = Priority_ResultError;
        return true;
    }
    bool NotificationScreenShot::SetupScreenCaptureError() NN_NOEXCEPT
    {
        m_pPanel->SetText("ScreenShot ... Error(Capture)");

        m_TimeToLive = config::NotificationTtl::GetTtlScreenShotFailure();
        m_Category   = NotificationCategory_ScreenShot;
        m_Priority   = Priority_ResultError;
        return true;
    }

}}
