﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationParentalControl.h"

#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationParentalControl::NotificationParentalControl() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetParentalControlTextColor());
        m_pPanel->SetTextPosition(Style::GetParentalControlTextPositionX(), Style::GetParentalControlTextPositionY());
        m_pPanel->SetTextSize(Style::GetParentalControlTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationParentalControl::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationParentalControl::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationParentalControl::SetupChanged() NN_NOEXCEPT
    {
        m_pPanel->SetText("Parental control has been changed");

        m_TimeToLive = config::NotificationTtl::GetTtlParentalControlChanged();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_ParentalControlChanged;
        return true;
    }

}}
