﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationAudioVolume.h"

#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationAudioVolume::NotificationAudioVolume() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelContainer>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pBackground = std::make_shared<panel::PanelText>();
        m_pBackground->SetPosition(Style::GetAudioVolumeIndicatorPosition());
        m_pBackground->SetSize(Style::GetAudioVolumeIndicatorSize());
        m_pBackground->SetColor(Style::GetAudioVolumeIndicatorBackgroundColor());
        m_pBackground->SetVisibility(panel::PanelVisibility::Visible);

        m_pForeground = std::make_shared<panel::PanelText>();
        m_pForeground->SetPosition(Style::GetAudioVolumeIndicatorPosition());
        m_pForeground->SetSize(Style::GetAudioVolumeIndicatorSize());
        m_pForeground->SetColor(Style::GetAudioVolumeIndicatorForegroundColor());
        m_pForeground->SetVisibility(panel::PanelVisibility::Visible);

        m_pTargetName = std::make_shared<panel::PanelText>();
        m_pTargetName->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pTargetName->SetSize(Style::GetSizeF());
        m_pTargetName->SetColor(Style::GetBackgroundColor());
        m_pTargetName->SetVisibility(panel::PanelVisibility::Visible);
        m_pTargetName->SetTextPosition(Style::GetAudioDeviceTextPositionX(), Style::GetAudioDeviceTextPositionY());
        m_pTargetName->SetTextSize(Style::GetAudioDeviceTextSize());
        m_pTargetName->SetTextColor(Style::GetAudioDeviceTextColor());

        m_pPanel->AddChild(m_pTargetName);
        m_pPanel->AddChild(m_pBackground);
        m_pPanel->AddChild(m_pForeground);
    }

    std::shared_ptr<panel::IPanel> NotificationAudioVolume::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationAudioVolume::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationAudioVolume::SetupVolume(Target target, float volume, bool isMute) NN_NOEXCEPT
    {
        const char* msg = "";
        if(!isMute)
        {
            switch(target)
            {
            case Target_Speaker:
                msg = "Speaker Volume";
                break;
            case Target_Headphone:
                msg = "Headphone Volume";
                break;
            case Target_Hdmi:
                msg = "Hdmi Volume";
                break;
            case Target_UsbOutputDevice:
                msg = "UsbOutputDevice Volume";
                break;
            default:
                msg = "Unknown Volume";
                break;
            }
        }
        else
        {
            switch(target)
            {
            case Target_Speaker:
                msg = "Speaker Volume(mute)";
                break;
            case Target_Headphone:
                msg = "Headphone Volume(mute)";
                break;
            case Target_Hdmi:
                msg = "Hdmi Volume(mute)";
                break;
            case Target_UsbOutputDevice:
                msg = "UsbOutputDevice Volume(mute)";
                break;
            default:
                msg = "Unknown Volume(mute)";
                break;
            }
        }
        m_pTargetName->SetText(msg);

        if(volume < 0)
        {
            volume = 0;
        }
        if(volume > 1)
        {
            volume = 1;
        }

        auto sizeMax = config::NotificationStyle::GetAudioVolumeIndicatorSize();
        m_pForeground->SetSize(nn::util::MakeFloat2(sizeMax.x * volume, sizeMax.y));

        m_TimeToLive = config::NotificationTtl::GetTtlAudioVolumeChanged();
        m_Category   = NotificationCategory_AudioVolume;
        m_Priority   = 0;
        return true;
    }


}}
