﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "SceneMenuPageBase.h"

namespace scene{ namespace menu{

    class SceneStackedItemMenuPageArgument
    {
    public:
        explicit SceneStackedItemMenuPageArgument(
            const std::shared_ptr<ui::IMenuItem>& pItem,
            const ui::Position& anchor
        ) NN_NOEXCEPT
            : m_pItem(pItem)
            , m_AnchorPosition(anchor)
        {
        }

        std::shared_ptr<ui::IMenuItem> GetItem() const NN_NOEXCEPT { return m_pItem; }
        ui::Position GetAnchorPosition() const NN_NOEXCEPT { return m_AnchorPosition; }

    private:
        std::shared_ptr<ui::IMenuItem> m_pItem;
        ui::Position m_AnchorPosition;
    };

    class SceneStackedItemMenuPage
        : public SceneMenuPageBase
    {
    public:
        explicit SceneStackedItemMenuPage(const std::shared_ptr<void>& arg) NN_NOEXCEPT;

        virtual bool IsTransparent() const NN_OVERRIDE { return true; }
    };

}}

