﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>

#include <nn/nn_Assert.h>
#include <nn/result/result_HandlingUtility.h>

#include "TextReaderImpl.h"

namespace scene { namespace debug { namespace logutil {

TextReaderImpl::TextReaderImpl(const char* data, const size_t& size) NN_NOEXCEPT
    : m_Data(data)
    , m_DataSize(size)
    , m_UsedCacheSize(0)
    , m_CacheHeadOffset(0)
{
}

nn::Result TextReaderImpl::GetByte(char* buffer, const int64_t& position)
{
    NN_ASSERT(!IsOutOfRange(position));
    NN_ASSERT_NOT_NULL(buffer);
    NN_ASSERT_NOT_NULL(m_Data);

    if(!IsCached(position))
    {
        LoadToCache(position);
    }

    *buffer = *(m_Cache + (position - m_CacheHeadOffset));
    NN_RESULT_SUCCESS;
}

void TextReaderImpl::LoadToCache(const int64_t & position)
{
    NN_ASSERT(!IsOutOfRange(position));

    auto loadSize = std::min<size_t>(sizeof(m_Cache), m_DataSize - position);

    memcpy(m_Cache, m_Data + position, loadSize);
    m_CacheHeadOffset = position;
    m_UsedCacheSize = loadSize;
}

}}}
