﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/nn_Common.h>
#include <nn/font/font_ScalableFont.h>
#include "TextReaderImpl.h"

namespace scene { namespace debug { namespace logutil {

class TextReader
{
public:
    TextReader() NN_NOEXCEPT;

    void Initialize(
        const char* binaryData,
        size_t dataSize,
        float lineWidthMax,
        float (*charWidthGetterFunction)(const char* character, size_t length, void* userPtr),
        void* charWidthGetterUserPtr
        ) NN_NOEXCEPT;

    // offset から取得した1文字と、読み込んだ後のデータ位置を返す
    nn::Result ReadUtf8Character(std::string* pOutChar, int64_t* pOutNextOffset, int64_t offset) NN_NOEXCEPT;

    // offset から取得した1行と、読み込んだ後のデータ位置を返す
    nn::Result ReadLine(std::string* pOutLine, int64_t* pOutNextOffset, int64_t offset) NN_NOEXCEPT;

private:
    float GetCharWidth(const char* character, size_t length) const NN_NOEXCEPT;

private:
    std::unique_ptr<TextReaderImpl> m_ReaderImpl;
    float m_LineWidthMax;
    float (*m_CharWidthGetterFunction)(const char*, size_t, void*);
    void* m_CharWidthGetterUserPtr;
};

std::string Sanitize(char inputData)NN_NOEXCEPT;

}}}
