﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../../panel/panel_IPanel.h"
#include "../../panel/panel_PanelContainer.h"
#include "../../panel/panel_PanelSharedTexture.h"
#include "debug_ActivitySystemSharedTextureViewer.h"

namespace scene{ namespace debug{

    class SystemSharedTextureViewer
    {
    public:
        explicit SystemSharedTextureViewer() NN_NOEXCEPT;

        void SetActivity(const ActivitySystemSharedTextureViewer& value) NN_NOEXCEPT;

        void Update() NN_NOEXCEPT;
        std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT;

    private:
        ActivitySystemSharedTextureViewer m_Activity = {};

        std::shared_ptr<panel::PanelContainer> m_pRootPanel;
        std::vector<std::shared_ptr<panel::PanelSharedTexture>> m_TextureList;
    };

}}
