﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <list>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include "debug_ILogStorage.h"

namespace scene{ namespace debug{

    class LogStorageLm
        : public ILogStorage
    {
    public:
        static const uint64_t LineCountMax = 40;
        static const size_t LogBufferSize = 8 * 1024;

    public:
        LogStorageLm() NN_NOEXCEPT;
        virtual ~LogStorageLm() NN_NOEXCEPT NN_OVERRIDE;

        virtual void GetLineRange(uint64_t* pOutLineBegin, uint64_t* pOutLineEnd) NN_NOEXCEPT NN_OVERRIDE;
        virtual void GetLineString(LogLineString* pOutValue, uint64_t line) NN_NOEXCEPT NN_OVERRIDE;
        virtual void SetAutoLineFeed(float lineWidthMax, float (*charWidthGetterFunction)(const char*, size_t, void*), void* charWidthGetterUserPtr) NN_NOEXCEPT NN_OVERRIDE;

        void Activate() NN_NOEXCEPT;
        void Deactivate() NN_NOEXCEPT;

        void Update() NN_NOEXCEPT;

    private:
        nn::os::Mutex m_Mutex;
        bool m_IsActive;

        uint64_t m_HeadIndex;
        uint64_t m_TailIndex;
        LogLineString m_LineList[LineCountMax];

        char m_LogBuffer[LogBufferSize];

        float m_LineWidthMax;
        float (*m_CharWidthGetterFunction)(const char*, size_t, void*);
        void* m_CharWidthGetterUserPtr;
    };

}}
