﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../../panel/panel_IPanel.h"
#include "../../panel/panel_PanelText.h"
#include "../../panel/panel_PanelContainer.h"
#include "debug_ActivityHidInputViewer.h"

namespace scene{ namespace debug{

    std::pair<int, int> CalculateHidInputViewerSize(int unitSize, int slotCount) NN_NOEXCEPT;

    class HidInputViewerImpl
    {
        class NpadView;
    public:
        HidInputViewerImpl(int unitSize, int viewSlotCount) NN_NOEXCEPT;
        ~HidInputViewerImpl() NN_NOEXCEPT;

        // 表示領域の大きさを計算する。
        static std::pair<int, int> CalculateViewSize(int unitSize, int slotCount) NN_NOEXCEPT;

        int GetUnitSize() const NN_NOEXCEPT { return m_UnitSize; }
        int GetViewSlotCount() const NN_NOEXCEPT { return m_ViewSlotCount; }
        std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT;

        void Update() NN_NOEXCEPT;
        void SetPosition(int x, int y) NN_NOEXCEPT;

    private:
        std::shared_ptr<panel::PanelContainer> m_pPanel;
        std::vector<std::shared_ptr<NpadView>> m_NpadViewList;

        int m_UnitSize = 1;
        int m_ViewSlotCount = 0;
        int m_ViewSlotSpacing = 0;
    };

    class HidInputViewer
    {
    public:

        void Update() NN_NOEXCEPT
        {
            if(auto p = m_pImpl)
            {
                p->Update();
            }
        }

        std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT
        {
            return m_pImpl ? m_pImpl->GetPanel() : nullptr;
        }

        void SetActivity(const ActivityHidInputViewer& value) NN_NOEXCEPT
        {
            if(m_pImpl)
            {
                bool isRebuildRequired = (value.scale != m_Activity.scale) || (value.slotCount != m_Activity.slotCount);
                if(isRebuildRequired)
                {
                    m_pImpl.reset();
                }
            }

            if(!m_pImpl)
            {
                m_pImpl = std::make_shared<HidInputViewerImpl>(value.scale, value.slotCount);
            }

            m_pImpl->SetPosition(value.common.positionX, value.common.positionY);
            m_Activity = value;
        }

    private:
        std::shared_ptr<HidInputViewerImpl> m_pImpl;
        ActivityHidInputViewer m_Activity = {};

    };

}}
