﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "debug_ActivityCommon.h"

namespace scene{ namespace debug{

    struct ActivitySystemSharedTextureViewer
    {
    public:
        enum Scale : uint32_t
        {
            Scale_Div4 = 4,
            Scale_Div8 = 8,
        };

    public:
#ifdef NN_DEVOVL_IS_SYSTEM
        static const bool IsSupported = true;
#else
        static const bool IsSupported = false;
#endif

        int GetWidth() const NN_NOEXCEPT
        {
            return 1280;
        }

        int GetHeight() const NN_NOEXCEPT
        {
            switch(this->scale)
            {
            case Scale_Div4: return 366;
            case Scale_Div8: return 90;
            default: return 0;
            };
        }

    public:
#ifdef NN_DEVOVL_IS_SYSTEM
        NN_DEVOVL_DEBUGMODULEACTIVITY_COMMON("SharedTextureViewer");
#else
        NN_DEVOVL_DEBUGMODULEACTIVITY_COMMON("reserved");
#endif
        Scale scale = Scale_Div4;
    };
}}
