﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "debug_ActivityCommon.h"

namespace scene{ namespace debug{

    // デバッグモジュールの設定用構造体。
    // 名前は "Activity<モジュール名>" とする。
    struct ActivityClock
    {
    public:
        // 現在のビルド条件でこのモジュールを使用可能か。
        // 例えば SDK 開発者用のモジュールは DevOverlayDispSystem でのみ true になるようにする。
        static const bool IsSupported = true;

        // モジュールの画面上の大きさを取得する関数。
        // 定数を返すか、 Activity の値から計算する。
        int GetWidth() const NN_NOEXCEPT
        {
            return 200;
        }

        int GetHeight() const NN_NOEXCEPT
        {
            return 24;
        }

    public:
        enum ClockType : uint32_t
        {
            ClockType_SystemClock = 0,
            ClockType_SystemTick,
        };

    public:
        // 共通のメンバの定義。
        // 構造体の先頭に来るようにする。つまり、これ以前にメンバ変数を定義してはならない。
        NN_DEVOVL_DEBUGMODULEACTIVITY_COMMON("Clock");

        // このモジュールに固有のメンバの定義。
        ClockType clockType;
    };

}}
